import { jsxs, jsx } from "react/jsx-runtime";
import { R as ReviewCard1 } from "./review-card-1-CxMzVFBi.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Carousel, a as CarouselContent, b as CarouselItem } from "./carousel-CcIeH0Ol.js";
import { g as getPageSection, S as Section, a as getPropertyArray } from "./section-DVceEJ6r.js";
import { c as cn } from "./utils-Dq7odfJT.js";
import { usePage } from "@inertiajs/react";
import Autoplay from "embla-carousel-autoplay";
import { ChevronLeft, ChevronRight } from "lucide-react";
import { useState, useEffect } from "react";
import "./card-DBOrqCcU.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "embla-carousel-react";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "lucide-react/dynamic";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "clsx";
import "tailwind-merge";
const Testimonials = () => {
  const { props } = usePage();
  const { customize } = props;
  const [api, setApi] = useState();
  const [currentSlide, setCurrentSlide] = useState(0);
  const testimonialsSection = getPageSection(props.page, "testimonials");
  useEffect(() => {
    if (!api) {
      return;
    }
    const handleSelect = () => {
      setCurrentSlide(api.selectedScrollSnap());
    };
    api.on("select", handleSelect);
    return () => {
      api.off("select", handleSelect);
    };
  }, [api]);
  return /* @__PURE__ */ jsxs(Section, { customize, pageSection: testimonialsSection, containerClass: "py-20", contentClass: "relative z-10", children: [
    /* @__PURE__ */ jsxs("div", { className: "mx-auto text-center md:max-w-[480px]", children: [
      /* @__PURE__ */ jsx("p", { className: "text-secondary-foreground mb-1 font-medium", children: testimonialsSection == null ? void 0 : testimonialsSection.title }),
      /* @__PURE__ */ jsx("h2", { className: "mb-4 text-3xl font-bold sm:text-4xl", children: testimonialsSection == null ? void 0 : testimonialsSection.sub_title }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: testimonialsSection == null ? void 0 : testimonialsSection.description })
    ] }),
    /* @__PURE__ */ jsx(
      Carousel,
      {
        setApi,
        className: "z-10 py-14",
        opts: {
          loop: true,
          align: "start",
          slidesToScroll: "auto"
        },
        plugins: [Autoplay({ delay: 5e3 })],
        children: /* @__PURE__ */ jsx(CarouselContent, { children: getPropertyArray(testimonialsSection).map((review) => /* @__PURE__ */ jsx(CarouselItem, { className: "md:basis-1/2 lg:basis-1/3 xl:basis-1/4", children: /* @__PURE__ */ jsx("div", { className: "h-full px-1.5 py-0.5", children: /* @__PURE__ */ jsx(ReviewCard1, { review }) }) }, review.id)) })
      }
    ),
    /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
      /* @__PURE__ */ jsx("div", { className: "flex items-center justify-center gap-2.5", children: api && getPropertyArray(testimonialsSection).map(({ id }, index) => /* @__PURE__ */ jsx(
        "div",
        {
          className: cn(
            "cursor-pointer rounded-full transition-all duration-200",
            currentSlide === index ? "bg-primary h-2 w-4" : "h-2 w-2 bg-gray-300"
          ),
          onClick: () => api.scrollTo(index)
        },
        id
      )) }),
      /* @__PURE__ */ jsxs("div", { className: "space-x-4", children: [
        /* @__PURE__ */ jsx(
          Button,
          {
            size: "icon",
            variant: "outline",
            disabled: !(api == null ? void 0 : api.canScrollPrev()),
            onClick: () => api == null ? void 0 : api.scrollPrev(),
            className: "hover:border-primary hover:bg-background",
            children: /* @__PURE__ */ jsx(ChevronLeft, {})
          }
        ),
        /* @__PURE__ */ jsx(
          Button,
          {
            size: "icon",
            variant: "outline",
            disabled: !(api == null ? void 0 : api.canScrollNext()),
            onClick: () => api == null ? void 0 : api.scrollNext(),
            className: "hover:border-primary hover:bg-background",
            children: /* @__PURE__ */ jsx(ChevronRight, {})
          }
        )
      ] })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:bottom-0 after:left-0 after:h-[240px] after:w-[240px] after:rounded-full after:bg-[rgba(0,167,111,1)] after:blur-[290px] after:content-['']" }),
    /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:top-0 after:right-0 after:h-[240px] after:w-[240px] after:rounded-full after:bg-[rgba(97,95,255,1))] after:blur-[290px] after:content-['']" })
  ] });
};
export {
  Testimonials as default
};
